﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private UnitBL _UnitBL = null;

        public UnitBL Unit
        {
            get
            {
                if (_UnitBL == null)
                {
                    _UnitBL = new UnitBL(this);
                }

                return _UnitBL;
            }
        }

        public class UnitBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public UnitBL(ZSBELearning BL) : base(BL) { }

            public List<PI.ZB.N1200.ELearning.BL.BO.View.Unit> Restore(long? ContextObjectID, PI.GM.N610.ELearning.BL.BO.Course Course, int? ExerciseDifficultyID)
            {
                PI.ZB.N1200.ELearning.BL.BO.View.Unit.Search _search = new BO.View.Unit.Search();
                _search.ExerciseDifficultyID = ExerciseDifficultyID;
                _search.ContextObjectID = ContextObjectID;
                _search.CourseID = Course.ID;
                _search.UserID = BLP.Environment.User.ID;


                return BLP.DAL.UnitView.Restore(_search);
            }

            public PI.ZB.N1200.ELearning.BL.BO.View.Unit Restore(BL.ZSBELearning.ContextParam ContextParam)
            {
                PI.ZB.N1200.ELearning.BL.BO.View.Unit _Unit = null;

                if (ContextParam.CourseType == Dictionary.Category.CourseType.Case)
                {
                    foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                    {
                        if (_loopUnit.ExerciseTotal.Value > 0)
                        {
                            decimal _exerciseDonePercent = (_loopUnit.ExerciseDone.Value * 100) / _loopUnit.ExerciseTotal.Value;

                            if (_loopUnit.ExerciseMaxPointDone == 0 && _exerciseDonePercent < ContextParam.RandomizePercent)
                            {
                                _Unit = _loopUnit;
                                break;
                            }
                        }
                    }

                }
                else
                {
                    foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                    {
                        if (_loopUnit.ExerciseTotal.Value > 0)
                        {
                            decimal _exerciseDonePercent = (_loopUnit.ExerciseDone.Value * 100) / _loopUnit.ExerciseTotal.Value;

                            if (_exerciseDonePercent < ContextParam.RandomizePercent)
                            {
                                _Unit = _loopUnit;
                                break;
                            }
                        }
                    }
                }

                return _Unit;
            }
        }
    }
}
